/*! \file tlk_cert_types_der.h 
**********************************************************************************
*Title:                         Discretix Certificate Handling Toolkit source file
*
* Filename:                     tlk_cert_types_der.h 
*
* Project, Target, subsystem:   Certificate Handling Toolkit, DER UTILITY externals
*
* Created:                      12.03.2009
*
* Modified:                     12.03.2009
*
* \Author                       Ira Boguslavsky
*
* \Remarks
*           Copyright (C) 2009 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/
#ifndef _TLK_CERT_TYPES_DER_H_
#define _TLK_CERT_TYPES_DER_H_
#ifdef __cplusplus
extern "C" {
#endif

#include "tlk_cert_types.h"
    /************************************************************************/
    /* General DER structures                                               */
    /************************************************************************/
    typedef struct 
    {
        DxUint16_t                                keyUsageBitMap;
        DxBool_t                                  criticalFlag;
        DxBool_t                                  reserved;
    }TLK_CERT_DER_KeyUsage_t;

    typedef struct 
    {
        DxBool_t                                  usedFlag;             /* this flag marks if we use this field  */
        DxBool_t                                  cA;
        DxBool_t                                  criticalFlag;
        DxBool_t                                  reserved1;
    }TLK_CERT_DER_BasicConstraints_t;

    typedef struct
    {
        DxUint8_t                                 tag;
        DxUint8_t                                 pad1;
        DxUint8_t                                 pad2;
        DxUint8_t                                 pad3;
        DxUint32_t                                buffSizeInBytes;              /*!<buffSizeInBytes                      - A length of the general buffer                                            **/
        DxByte_t                                 *buff_ptr;                     /*!<buff_ptr                             - A pointer to the general buffer                                           **/
    }TLK_CERT_DER_Buffer_t;

    /************************************************************************/
    /* Request Create Input Structures                                      */
    /************************************************************************/
    typedef struct  
    {
        TLK_CERT_Buffer_t                         commonName;
        TLK_CERT_Buffer_t                         countryName;
        TLK_CERT_Buffer_t                         localityName;
        TLK_CERT_Buffer_t                         stateOrProvinceName;
        TLK_CERT_Buffer_t                         organizationName;
        TLK_CERT_Buffer_t                         organizationalUnitName;
        TLK_CERT_Buffer_t                         serialNumber;
    }TLK_CERT_DER_SubjectNameParams_t;

    typedef struct
    {
        TLK_CERT_DER_BasicConstraints_t           basicConstraints;
        TLK_CERT_DER_KeyUsage_t                   keyUsage;
    }TLK_CERT_DER_Attributes_t;

    typedef enum
    {
        TLK_CERT_PKCS10_V0 = 0,

        TLK_CERT_PKCS10_LAST_VERSION = 0x7FFFFFFF
    }TLK_CERT_DER_VersionNumber_t;

    typedef enum
    {
        TLK_CERT_DER_md2_With_RSA_Encryption    = 0,
        TLK_CERT_DER_md5_With_RSA_Encryption    = 1,

        TLK_CERT_DER_SIGNATURE_ALGORITHM_LAST   = 0x7FFFFFFF
    }TLK_CERT_DER_SignatureAlg_t;

    typedef struct
    {
        TLK_CERT_Buffer_t                 publicKeyModulusBitString;
        TLK_CERT_Buffer_t                 publicKeyExponentBitString;
        TLK_CERT_Buffer_t                 privateKeyExponentBitString;
    }TLK_CERT_DER_KeyPairData_t;


#ifdef __cplusplus
}
#endif
#endif
